/***************************************/
/**                                   **/
/** AMSTRAD/Schneider CPC-Emulator    **/
/** for Linux and X11                 **/
/**                                   **/
/** GNU GENERAL PUBLIC LICENSE        **/
/** 1999, 2000, 2001                  **/
/** Ulrich Cordes                     **/
/** Vor der Dorneiche 1               **/
/** 34317 HABICHTSWALD / Germany      **/
/**                                   **/
/** email:  ulrich.cordes@gmx.de      **/
/** WWW:    http://www.amstrad-cpc.de **/
/**                                   **/
/***************************************/

/*
 *  If you want to make changes, please do not(!) use TABs !!!!!
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include "Z80.h"
#include "defines.h"
#include "cpc.h"
#include "screen.h"

byte SystemROM[16384];
byte *RAM;                 /* 128 kbyte */
byte *UpperROM [8];        /* BASIC-ROM and 7 external ROMs */
byte ROMPresent[255];

unsigned long BankAddr[4];

int ROMNumber;
int LowerBlockIsRAM;
int UpperBlockIsRAM;
int RS_UpBlockRAM;
int RS_LoBlockRAM;


int InitMem (void){
  static int file, length;
  static unsigned long i,j;
  static char filename [128];

  
  j = CPCMaxMem * 1024;
  if (RAM==NULL)
    RAM = (byte *)malloc (j);
  if (RAM == NULL)
    return 0;
  for (i=0; i<=65535; i++)
    RAM[i]=0;

  for (i=0; i<=255; i++)
      ROMPresent[i]=FALSE;

  for (i=1; i<=7; i++) {
    length = strlen (ROMFile[i]);
    if (length>1) {
      /* Allocate 16 kbytes memory for the ROM file */
      if (UpperROM[i]==NULL)
        UpperROM[i] = (byte *)malloc (16384);
      /* Generate full ROM file name */
      sprintf (filename, "%s/rom/%s", WorkDirectory, ROMFile[i]);

      // Last char must be '\0' instead of '\n'
      length = strlen (filename) - 1;
      if (filename[length] < 32)
         filename [length] = '\0';

      file = open (filename, O_RDONLY);
      if (file != -1) {
        read(file, UpperROM[i], 16384);
        close (file);
        /* Test if ROM file keeps a DOS header in the first 128 bytes (2nd byte is a char) */
        if (UpperROM[i][1]>31) {
          /* Eliminate the DOS header by reopening ROM file, read */
          /* first 128 dummy bytes and then read ROM data.        */
          file = open (filename, O_RDONLY);
          read(file, UpperROM[i], 128);
          read(file, UpperROM[i], 16384);
          close (file);
        }
        ROMPresent[i]=TRUE;
      }
    }
  }

  /* Select system ROM */
  if (UpperROM[0]==NULL)
    UpperROM[0] = (byte *)malloc (16384);
  switch (CPCtype) {
    case 2  : sprintf (filename, "%s/rom/cpc6128.rom", WorkDirectory); break;
    case 1  : sprintf (filename, "%s/rom/cpc664.rom", WorkDirectory); break;
    default : sprintf (filename, "%s/rom/cpc464.rom", WorkDirectory); CPCtype=0; break;
  }

  /* Read system ROM */
  file = open (filename, O_RDONLY);
  if (file != -1) {
    read(file, SystemROM, 16384);
    read(file, UpperROM[0], 16384);
    ROMPresent[0]=TRUE;
    close (file);
    ROMNumber = 0;
    LowerBlockIsRAM = FALSE;
    UpperBlockIsRAM = FALSE;
    ScreenBlock = 0xC000;
    return 1;
  }
  else return 0;
}


void ExitMem (void) {
  int i;
  printf ("Free ROM memory no ");
  for (i=0; i<=7; i++) {
    printf ("%i  ",i);
    free (UpperROM[i]);
  }
  printf (" ..... ok!\nFree RAM memory");
  free (RAM);
  printf (" ..... ok!\n");
}


void SelectRamBank (byte Bank) {
  // Calculate offsets for the four 16 k blocks while RAM access
  // printf ("Bank %d\n", Bank);
  static int block;
  if (CPCMaxMem==576)
    block = (Bank >> 3) & 7;
  else
    block = 0;
  switch (Bank & 0x07) {
    case 0:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x000000;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x000000;
      break;

    case 1:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x000000;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x010000 + 0x010000 * block;
      break;

    case 2:
      BankAddr[0]=0x010000 + 0x010000 * block;
      BankAddr[1]=0x010000 + 0x010000 * block;
      BankAddr[2]=0x010000 + 0x010000 * block;
      BankAddr[3]=0x010000 + 0x010000 * block;
      break;

    case 3:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x008000;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x010000 + 0x010000 * block;
      break;

    case 4:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x00C000 + 0x010000 * block;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x000000;
      break;

    case 5:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x010000 + 0x010000 * block;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x000000;
      break;

    case 6:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x014000 + 0x010000 * block;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x000000;
      break;

    case 7:
      BankAddr[0]=0x000000;
      BankAddr[1]=0x018000 + 0x010000 * block;
      BankAddr[2]=0x000000;
      BankAddr[3]=0x000000;
      break;

    default: break;
  }
}

void WrZ80 (register word Addr, register byte Value) {
  static byte Bank;
  Bank = (Addr>>14) & 0x0003;
  RAM [BankAddr[Bank] + (unsigned long)Addr] = Value;
  if (((Addr & 0xC000) == ScreenBlock) && (BankAddr[ScreenBank]==0)) WrScreenMem (Addr,Value);
}


byte RdZ80(register word Addr) {
  static byte Bank;

  /* Get 16k block no */
  Bank = Addr>>14;

  /* Test if lower ROM access. If true return lower ROM byte */
  if ((Bank==0) && (LowerBlockIsRAM==FALSE))
    return SystemROM [Addr & 0x3FFF];

  /* Test if upper ROM access. */
  if ((Bank==3) && (UpperBlockIsRAM==FALSE)) {
    if (ROMPresent[ROMNumber])
      return UpperROM[ROMNumber][Addr & 0x3FFF];
    else
      return UpperROM[0][Addr & 0x3FFF];
  }
  /* RAM access */
  return RAM [BankAddr[Bank] + (unsigned long)Addr];
}
