# *************************
# help.tcl
# *************************

wm title . "Help"
set workdir ""
set installdir ""
set browser ""

set fid [open $env(HOME)/.cpc4xrc r]
  gets $fid installdir
  gets $fid workdir
close $fid

set browsertype 1
# -----------------------------------------------------------------------

proc cmd_Close {} {
  global workdir browsertype browser
  set fid [open $workdir/.dlghelp w]
    puts $fid "CLOSE"
    puts $fid $browsertype
    puts $fid $browser
  close $fid
  destroy .
}

proc cmd_ReadHelp {} {
  global workdir browsertype browser
  set fid [open $workdir/.dlghelp w]
    puts $fid "READ"
    puts $fid $browsertype
    puts $fid $browser
  close $fid
  destroy .
}


# -----------------------------------------------------------------------

image create photo amstrad -file $installdir/menus/cpc4x_intro.gif
canvas .logo -width 370 -height 185
.logo create image 0 0 -image amstrad -anchor nw
pack .logo -side top
if [file exists $workdir/.dlghelp] {
  set fid [open $workdir/.dlghelp r]
    gets $fid tmp
    gets $fid browsertype
    gets $fid browser
  close $fid
}

frame .help -borderwidth 10
label .help.head -justify left -anchor w -text "Function keys"
frame .help.msg
message .help.msg.keys -aspect 1000 -justify left -anchor w -text \
"F1
F3
F4
F5
F6
F7
F8
F9
F10
F12"
message .help.msg.descr -aspect 1000 -justify left -anchor w -text \
"- This info
- Insert a disc image in drive A:
- Insert a disc image in drive B:
- Sound on/off
- Save the CPC screen as XPM file
- Setup
- Reset the emulation
- Close printer file and send it to the printer
- Start the built-in Z80 debugger
- Exit"

pack .help.msg.keys .help.msg.descr -side left
pack .help.head .help.msg -side top -anchor w
pack .help -side top -anchor w

frame .browser -borderwidth 10
label .browser.head -justify left -anchor w -text "Help reader"

radiobutton .browser.kdehelp -variable browsertype -value 1 -text "Use KDE help browser"
radiobutton .browser.netscape -variable browsertype -value 2 -text "Use Netscape"
frame .browser.own
radiobutton .browser.own.b -variable browsertype -value 3
entry .browser.own.e -textvariable browser -relief sunken
pack .browser.own.b .browser.own.e -side left -anchor w
pack .browser.head .browser.kdehelp .browser.netscape .browser.own -side top -anchor w
pack .browser -side top -anchor w

frame .buttons -borderwidth 10
button .buttons.close -command cmd_Close -text "Goto emulation"
button .buttons.readhelp -command cmd_ReadHelp -text "Read help"
pack .buttons.readhelp .buttons.close -side left
pack .buttons -side top -anchor e

