/* AIFF decoder, (c) Pierre Guerrier 1996-98 */
/*      e-mail: Pierre.Guerrier@lip6.fr      */
/*       see attached "read_me" file      */
/*  version 1.3,  released october 1998  */

// Code made DJGPP compatible by Ulrich Doewich
// questions? contact me via caprice32@cybercube.com

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MSDOS   1
/* change this value to 1 if you are compiling for DOS */
#define MACOS   0
/* change this value to 1 if you are compiling for MAC */
#define SUNOS   0
/* change this value to 1 if you are compiling for U*X */

#if MACOS == 1
#include <sioux.h>
#endif


FILE *Source;
FILE *Target;
FILE *Log;






#define kNo   0    /* nothing under way */
#define kArm  1    /* leader caught */
#define kHead 2    /* syncs found */
#define kData 3
#define kNULL (-300)

#define kHeadSync (0x2c | (127<<9))
#define kDataSync (0x16 | (127<<9))
#define kHeadSize 256
#define kDataSize 2048
#define kCRCSizeH 2
#define kCRCSizeD 16    /* approximate trailer size */
#define kCRCpoly  4129  /* used for binary long division in CRC */
#define kLeadSize 2000 /* leader size in "one" bits */
#define kTreshold 500  /* duration limit between a 0 and a 1, in CPU clocks */
#define kTopOut   50   /* <<<<---- problematic !! */
#define kTopIn    3




/* signal processing options globals */

long AIFFstart;
unsigned char bits,channels;
long rate;

int hasRight;       /* 1 if file has a second channel */
int Polarity;   /* no sign change */
int Step;
int Ratio;
int SlowRate;

/* globals for delta->bit->byte levels state machines */

int WMin;
int W0Low;
int W0High;
int W1Low;
int W1High;
int WTopIn;
int WTopOut;
int WLine;

unsigned int window;
int bitPt;
int bytePt;
int engaged;
int accumulator;
long Counter;
long remind;
int FFound;

/* globals for byte->file level state machine */

int LostCount = 1;

char pastFiles[12][128];          /* no-clubber memory */
int maxPast = 0;
char currentFile[17], prevFile[17];
unsigned char BlockBuff[kDataSize+kCRCSizeD];
int currentBlock;
unsigned int currentSize;
unsigned int currentSize2;
int closeOnNext;
int isOpen;
int BlockReady;







/*----------------------------------------------------------------------\
|            delta times to bits and bits to bytes engines              |
\----------------------------------------------------------------------*/

int sendDelta(int delta)
{
 int retVal;

 window = (window<<1) | (delta > WLine);
  /* shifting window */

 switch (engaged)   /* finite state machine DSP :-) */
  {
  case kArm:
   if ((window&0xFFFF)==kHeadSync)
         {
         engaged = kHead;
         fprintf(Log, "\nSample %ld: Found a HEADER Sync !\n", Counter);
         }
   if ((window&0xFFFF)==kDataSync)
         {
         engaged = kData;
         fprintf(Log, "\nSample %ld: Found a BLOCK Sync !\n", Counter);
         }
   bitPt  = 0;
   bytePt = 0;
   retVal = kNULL;
   accumulator--;
   if ((accumulator < 0) && (engaged == kArm))
     { engaged = kNo; accumulator = 0; fprintf(Log, "Disarmed...\n"); }
   break;

  case kHead: case kData:
   bitPt++;
   if (bitPt == 8)
     {
     bitPt = 0;
     bytePt++;
     retVal = window & 255;
     if ( ((engaged == kHead) && (bytePt == (kHeadSize+kCRCSizeH))) ||
          ((engaged == kData) && (bytePt == (currentSize+kCRCSizeD))) )
           { engaged = kNo; accumulator = 0; }
     }
    else
     retVal = kNULL;
   break;

  case kNo:        /* leader management */
   retVal = kNULL;
   if ((window  & 0xFFFF) == 0xFFFF) accumulator++;
   if (accumulator > kLeadSize)
      { engaged = kArm;
        fprintf(Log, "Sample %ld: Found a leader ...", Counter);
        accumulator = 8*kHeadSize; }
   break;
  }

 return(retVal);
}


/*----------------------------------------------------------------------\
|                       bytes to files engines                          |
\----------------------------------------------------------------------*/

unsigned int CRCupdate(unsigned int CRC, unsigned char new)
{
 unsigned int aux = CRC ^ (new << 8);
 int i;

 for(i=0; i<8; i++)
   if (aux & 0x8000)
       aux = (aux <<= 1) ^ kCRCpoly;
     else
       aux <<= 1;

 return(aux);
}


unsigned int CRCheck(unsigned char* buffer, unsigned int size)
{
int chunks;
int error = 0;
int i,j, offset1,offset2;
unsigned int CRC;


 chunks = size >> 8;

 for(i=0; i<chunks; i++)
  {
  CRC = 0xFFFF;
  offset1 = 256*i;
  offset2 = 258*i;
  for(j=0; j<256; j++)
    CRC = CRCupdate(CRC, buffer[offset1+j] = buffer[offset2+j]);
  CRCupdate(CRC, 0);
  CRCupdate(CRC, 0);
  if ((~CRC & 0xFFFF) != (buffer[offset2+257]+256*buffer[offset2+256])) error = 1;
  }

 return(error);
}


void Tape2DOS(void)
{
unsigned char AuxBuff[128];
unsigned int CRC = 0;
char nameBuff[12];
char *curs;
int newBlock,firstBlock;
int i,j,s, hit;
char c,x;
char k = 'A';

 sprintf(prevFile, "%s", currentFile);
 for(i=0; i<16; i++) currentFile[i] = BlockBuff[i];
 prevFile[16] = 0;
 newBlock = BlockBuff[16];
 closeOnNext = BlockBuff[17];
 currentSize2 = currentSize = BlockBuff[19]+256*BlockBuff[20];
 firstBlock = BlockBuff[23];
 if (CRCheck(BlockBuff, kHeadSize))
  fprintf(Log,"    ****    Incorrect HEADER checksum !\n"); 


  fprintf(Log,"            Found header for block %d of file %s\n", newBlock, currentFile);

 if (!firstBlock && (newBlock != (currentBlock+1)) )
    fprintf(Log,"    ****    Missed some blocks of file %s !\n", currentFile);

 if (currentSize > kDataSize)
     {
     currentSize = kDataSize;
     fprintf(Log,"    ****    Block size error !\n");
     }
   else
     fprintf(Log,"            Data block size %d bytes\n", currentSize);
 i = currentSize & 0xFF00;   /* padding */
 if (currentSize & 0xFF) i+= 256;
 currentSize = i;
 currentBlock = newBlock;
 BlockReady = 1;

 s = strlen(currentFile);  /* name conversion function */
 j = 0;
 for(i=0; i<11; i++)
  {
  if (j<s)
   {
   c = toupper(currentFile[j++]);
   if (c == '.')
      {
      if (i>7)  i--;
         else { x = '_'; j--; }
      }
     else
      { if (!isalnum(c)) x = '#'; else x = c; }
   }
   else x = '_';
  nameBuff[i] = x;
  }
 for(j=10; nameBuff[j] == '_'; j--) ;
 nameBuff[j+1] = 0;

  /* no-clubber feature */

retest:
 for(i=0; i<maxPast; i++)
	if (!strncmp(nameBuff, pastFiles[i], 11)) break;
 if (i<maxPast) { nameBuff[j] = k++; goto retest; }

 sprintf( pastFiles[maxPast], "%s", nameBuff);
 maxPast++;




 if (strncmp(currentFile, prevFile, 16))
      { /* the file names differ */
      if (isOpen)
        {
        if (closeOnNext)
          {                     /* fine completion */
          closeOnNext = 0;
          fclose(Target);
          isOpen = 0;
          fprintf(Log, "    >>>>    File %s terminated properly...\n", prevFile);
	  FFound = 1;
          }
         else
          {
          fclose(Target);       /* we missed the end of prev file */
          fprintf(Log,"    ****    File %s did not terminate properly !\n", currentFile);
          }
        }
      fprintf(Log, "    >>>>    Saving tape file %s as disc file %s\n", currentFile, nameBuff);
      Target = fopen(nameBuff, "wb");
      isOpen = 1;    
      }
    else /* the file names are identical */
      goto end; /* the header has already been created */

 fprintf(Log, "            Indicated total size %d bytes\n", BlockBuff[24]+256*BlockBuff[25]);
 if (BlockBuff[18] & 0xF0) goto end;  /* No header for ASCII files */
 fprintf(Log, "            File is not ASCII, creating AMSDOS header:\n");
  switch((BlockBuff[18]&0x0F)>>1)
   {
   case 0:
      fprintf(Log, "            Locomotive BASIC file\n");
      break;
   case 1:
      fprintf(Log, "            Binary File, origin %d, entry %d\n",
                           BlockBuff[21]+256*BlockBuff[22],
                           BlockBuff[26]+256*BlockBuff[27]);
      break;
   case 2:
      fprintf(Log, "            Binary Screen Image\n");
      break;
   case 3:
      fprintf(Log, "    ****    Inconsistent file typing: ASCII\n");
      break;
   }

 for(i=0; i<128; i++) AuxBuff[i] = 0;
 for(i=0; i<11; i++)
    if (BlockBuff[i]) AuxBuff[i+1] = BlockBuff[i];
               else   AuxBuff[i+1] = ' ';

 for(i=18; i<28; i++) AuxBuff[i] = BlockBuff[i];
 AuxBuff[23] = 255;
 AuxBuff[64] = BlockBuff[24];
 AuxBuff[65] = BlockBuff[25];

 for (i=0; i<67; i++) CRC += AuxBuff[i];
 AuxBuff[67] = CRC & 255;
 AuxBuff[68] = (CRC >> 8) & 255;
 for (i=0; i<128; i++) fputc(AuxBuff[i], Target);

end:
}


void saveData(void)
{
 int i;

 if (CRCheck(BlockBuff, currentSize))
   fprintf(Log, "    ****    Incorrect DATA checksum !\n");

 for(i=0; i<currentSize2; i++)
   fputc(BlockBuff[i], Target);
 fprintf(Log, "            Saving block %d of file %s\n", currentBlock, currentFile);
 BlockReady = 0;
}


void rescueData(void)
{
 int  i;
 char Lost[8];

 sprintf(Lost, "LOST%d", LostCount);
 Target = fopen(Lost, "ab");

 if (CRCheck(BlockBuff, kDataSize))
   fprintf(Log, "    ****    Incorrect DATA checksum !\n");

 for(i=0; i<kDataSize; i++)
        fputc(BlockBuff[i], Target);
 fprintf(Log, "    ****    One data block rescued (number %d)!\n", LostCount++);
 fclose(Target);
}


void SendByte(unsigned char newByte)
{
 BlockBuff[bytePt-1] = newByte;
 
 if (engaged == kNo) /* the byte received is the last of a block or header */
   {                 /* bytePt still holds correct count */
   if (bytePt == (currentSize+kCRCSizeD))
       {if (isOpen && BlockReady) saveData(); else rescueData(); }
                               /* if data found without header */
   if (bytePt == (kHeadSize+kCRCSizeH)) Tape2DOS();
   }
}



/*----------------------------------------------------------------------\
|                        waves to delta time engine                     |
\----------------------------------------------------------------------*/

int getNext(void)
{
 int buffer, retVal;

 Counter++;
 if (Step) fseek(Source, Step, 1);
 if ((buffer = fgetc(Source)) == EOF) 
       {
       fprintf(Log, "%ld samples scanned. Offset %ld\n\n",Counter, ftell(Source));
       return(kNULL);
       }
 if (buffer>>7) retVal = buffer-256; else retVal = buffer;
 if (Polarity) retVal = -retVal;
 return(retVal);
} 


int filter(int s0, int s1, int delta)
{
      if (delta<W0Low)
         {
         if ((engaged != kNo) && ( ((s0<0)&&(s1>=0)) || ((!s0)&&(s1>0)) ))
            { if (! (delta<WMin))
                   {
                   fprintf(Log,"    ****    Narrow strobe in data, sample %ld\n", Counter);
                   return(1);
                   }
                else return(0);
            }
          else return(0);
         }
      else if (delta<W0High) return( ((s0<0)&&(s1>=0)) || ((!s0)&&(s1>0)) );
      else if (delta<W1Low) 
              {  /* shitty case */
              if ( ((s0<0)&&(s1>=0)) || ((!s0)&&(s1>0)) )
                {
/*	not so important and floods the logfile...
                if (engaged != kNo)
                   fprintf(Log, "    ****    Bad strobe in data at sample %d\n", Counter);
*/
                return(1);
                }
               else return(0);
              }
      else if (delta<W1High) return( ((s0<0)&&(s1>=0)) || ((!s0)&&(s1>0)) );
      else if ((engaged != kNo) || remind )
         {
         if (delta>WTopIn)
              {
              fprintf(Log,"    ****    Wide strobe in data, samples %ld-%ld\n", remind, Counter);
              remind = 0;
              return(1); }
          else { if (!remind) remind = Counter;  /* begin wide arch */
                 return(0); }
         }
      else return(delta > WTopOut);
}


void doProcess(void)
{
 int last, new, delta, resByte;

 delta = 1;

 while ((new = getNext()) != kNULL)
  {
  if ( filter(new, last, delta) )  /* raising slope inversion */
     {
     resByte = sendDelta(delta);              /* bit->bytes/blocks   */
     if (resByte != kNULL) SendByte(resByte); /* bytes/blocks->files */
     delta = 1;
     }
    else
     delta++;

  last = new;
  }

 if (isOpen)
   {
   if ((engaged == kNo) || (engaged == kArm))  /* not in data */
     {
     if (closeOnNext && !BlockReady)  /* all fine */
       { fprintf(Log, "    >>>>    File %s terminated properly.\n\n",currentFile);
	 FFound = 1; }
      else 				 /* missed some blocks */
       {
       fprintf(Log,"    ****    File %s did not terminate properly !\n\n", currentFile);
       rescueData();
       }
     }
    else		/* in data */
     {
     fprintf(Log,"    ****    File %s did not terminate properly !\n\n", currentFile);
     rescueData();
     }
   }
  else
   if (engaged == kData) rescueData();
}


/*----------------------------------------------------------------------\
|                   initializes filter parameters                       |
\----------------------------------------------------------------------*/

void makeWindows(void)
{
 WLine = (SlowRate*kTreshold)/Ratio;  /* (CPU clocks/one)/(ticks/sample) -> sample/one */
 WMin = WLine/2;           /* WMin = 2, WTopIn = 15, WTopOut = 250 */
 W0Low = WLine/2 +1;       /* WLine = 5, W0Low = 3, W0High = 6, W1Low = 7, W1High = 10 */
 W0High = WLine+1;
 W1Low = (3*WLine)/2;
 W1High = WLine*2;
 WTopIn = kTopIn*WLine;
 WTopOut = kTopOut*WLine;
}


void resetFSM(void)
{
window = 0;
bitPt  = 0;
bytePt = 0;
engaged = kNo;
accumulator = 0;
Counter = 0;
remind = 0;
closeOnNext = 0;
isOpen = 0;
BlockReady = 0;
currentSize = currentSize2 = 2048;
}



/*----------------------------------------------------------------------\
|                   data formatting service routines                    |
\----------------------------------------------------------------------*/

int checkAIFF(void)
{
 int  i;
 unsigned char buffer[256];
 char *aux;
 unsigned char exponent,mantissa;

 for(i=0; i<255; i++)
      { buffer[i] = fgetc(Source);  if (buffer[i] == '\0') buffer[i] = ' ';}
 buffer[i] = '\0';
 if ( (strstr(buffer, "AIFF") != NULL) ||
        ((strstr(buffer, "AIFC") != NULL) && (strstr(buffer, "NONE") != NULL)) )
    {
    aux = strstr(buffer, "COMM");
    channels = *(aux+9);
    bits = *(aux+15);
    exponent = *(aux+17);
    mantissa = *(aux+18);
    rate = ((long)mantissa) << (exponent-6);    /* result is approx. Hz */

    fprintf(Log, "File is %d-bit, %d-channeled, %ld Hz\n\n",(int)bits,(int)channels, rate);

    AIFFstart = ((unsigned long)strstr(buffer, "SSND")-(unsigned long)buffer)+16;
    hasRight = (channels > 1);
    return(1);
    }
  else
     return(0);
}


/* compute cursor step length */

void makeStep(void)
{
long nyquist = (9600/SlowRate)*4;

    Step = 1;
    if (rate < nyquist)
        fprintf(Log, "Unable to process file with optimal Nyquist frequency\n");
      else
        Step *= rate/nyquist;                 /* will filter high frequencies */
              /* number of CPC clock cycles per sample after Step-decimation: */
    Ratio = (int)( ((long)Step * 3993600L) / rate);
    Step *= channels;
    if (bits>8) Step *= 2;
    fprintf(Log, "Adopting sample step = %d\n", Step);
    Step--;   /* because fgetc will move 1 step forward ..  */
}


/* goes to the beginning of the audio data for a given channel */

void resetChannel(int number)   /* 1 = right, or second, channel */
{
 int i;

 fseek (Source, AIFFstart , 0);
 if (number && hasRight)
   { fgetc(Source); for(i=0; i<Step; i++) fgetc(Source); }
}









/*--------------------------------------------------------\
|      This does, er, well, it does the job ...           |
\--------------------------------------------------------*/

void doTheJob(void)
{
 int i,j;
 int bad[2][2];

 for(i=0; i<2; i++)
  for(j=0; j<2; j++)
   bad[i][j] = 0;

 for(i=0; i<12; i++)
   for(j=0; j<128; j++) pastFiles[i][j] = 0;

 for(i=0; i<2; i++)
  for(Polarity = 0; Polarity < 2; Polarity++)
   {
   if (bad[i][Polarity]) continue;

   fprintf(Log, "\nTrack %d, Polarity %s\n\n", i, Polarity?"up":"down");
   FFound = 0;

   fprintf(Log, "Trying 2400 bps (Speed 1)\n\n");
   SlowRate = 4;
   makeStep();
   makeWindows();
   resetFSM();
   resetChannel(i);
   doProcess();

   fprintf(Log, "Trying 1200 bps (Speed 0)\n\n");
   SlowRate = 8;
   makeStep();
   makeWindows();
   resetFSM();
   resetChannel(i);
   doProcess();

   if (FFound) fprintf(Log, "Files properly decoded in this track/polarity... discarding others\n");
   bad[i][1-Polarity] = 1;
   bad[1-i][1-Polarity] = 1;
   bad[1-i][Polarity] = 1;
   }
}


void doFile(char *theFile)
{
 char SourceName[256];
 int i;

 Log = fopen("LOGFILE", "w");

 fprintf(Log, "AIFF Decoder 1.3, (c) 1998 Pierre Guerrier\n\n");

 if (MSDOS) sprintf (SourceName, "%s.aif", theFile);
       else sprintf (SourceName, "%s.aiff", theFile);

 if ((Source = fopen(SourceName,"rb")) == NULL)
   { fprintf(Log, "Unable to open %s, trying %s\n", SourceName, theFile);
     if ((Source = fopen(theFile,"rb")) == NULL)
        { fprintf(Log, "Unable to open %s\n", theFile);
          exit(3); } }
     
 if (checkAIFF())
     doTheJob();
    else
     { fprintf(Log,"File %s is not valid uncompressed AIFF !\n", theFile); exit(2); }
 fclose(Source);
 fclose(Log);
}


int main(int argc, char **argv)
{

 #if MACOS == 0
 if (argc == 2) { doFile(argv[1]); exit(0); }
 fprintf(stderr,"Usage: %s AIFF-file\n", argv[0]);
 #endif

exit(1);
}
